clear
set mem 800m
set more off
use "WVS\xwvsevs_1981_2000_v20060423.dta", clear
keep if x003>=18 | x003==. /* Restrict sample to adults; no age codes for HUN, KOR*/
* Using s003a as the country variable: Today's countries, followed back through history.
gen str3 cty=""
replace cty="ALB" if s003a==8
replace cty="DZA" if s003a==12
replace cty="AZE" if s003a==31
replace cty="ARG" if s003a==32
replace cty="AUS" if s003a==36
replace cty="AUT" if s003a==40
replace cty="BGD" if s003a==50
replace cty="ARM" if s003a==51
replace cty="BEL" if s003a==56

replace cty="BRA" if s003a==76
replace cty="BGR" if s003a==100
replace cty="BLR" if s003a==112
replace cty="CAN" if s003a==124
replace cty="CHL" if s003a==152
replace cty="CHN" if s003a==156
replace cty="TWN" if s003a==158
replace cty="COL" if s003a==170
replace cty="HRV" if s003a==191
replace cty="CZE" if s003a==203
replace cty="DNK" if s003a==208
replace cty="DOM" if s003a==214
replace cty="SLV" if s003a==222
replace cty="EST" if s003a==233
replace cty="FIN" if s003a==246
replace cty="FRA" if s003a==250
replace cty="GEO" if s003a==268

replace cty="GRC" if s003a==300
replace cty="HUN" if s003a==348
replace cty="ISL" if s003a==352
replace cty="IND" if s003a==356
replace cty="IDN" if s003a==360
replace cty="IRN" if s003a==364
replace cty="IRQ" if s003a==368
replace cty="IRL" if s003a==372
replace cty="ISR" if s003a==376
replace cty="ITA" if s003a==380
replace cty="JPN" if s003a==392
replace cty="JOR" if s003a==400
replace cty="KOR" if s003a==410
replace cty="KGZ" if s003a==417
replace cty="LVA" if s003a==428
replace cty="LTU" if s003a==440
replace cty="LUX" if s003a==442
replace cty="MLT" if s003a==470
replace cty="MEX" if s003a==484
replace cty="MDA" if s003a==498
replace cty="MAR" if s003a==504
replace cty="NLD" if s003a==528
replace cty="NZL" if s003a==554
replace cty="NGA" if s003a==566
replace cty="NOR" if s003a==578
replace cty="PAK" if s003a==586
replace cty="PER" if s003a==604
replace cty="PHL" if s003a==608
replace cty="POL" if s003a==616
replace cty="PRT" if s003a==620
replace cty="PRI" if s003a==630
replace cty="ROM" if s003a==642  /*Is it ROM or ROU?*/
replace cty="RUS" if s003a==643
replace cty="SAU" if s003a==682
replace cty="SGP" if s003a==702
replace cty="SVK" if s003a==703
replace cty="VNM" if s003a==704
replace cty="SVN" if s003a==705
replace cty="ZAF" if s003a==710
replace cty="ZWE" if s003a==716
replace cty="ESP" if s003a==724
replace cty="SWE" if s003a==752
replace cty="CHE" if s003a==756
replace cty="TUR" if s003a==792
replace cty="UGA" if s003a==800
replace cty="UKR" if s003a==804
replace cty="MKD" if s003a==807
replace cty="EGY" if s003a==818
replace cty="GBR" if s003a==826
replace cty="TZA" if s003a==834
replace cty="USA" if s003a==840
replace cty="URY" if s003a==858
replace cty="VEN" if s003a==862
replace cty="DEU" if s003a==900 /* This is the code I use for West Germany (should be DEU) */
replace cty="DDR" if s003a==901 /* Actual code should be DDR */
replace cty="NIR" if s003a==909 /* There is no official code for Northern Ireland*/
replace cty="SRB" if s003a==911
replace cty="MNE" if s003a==912
replace cty="SRP" if s003a==913 /* Srpska is officially part of BIH - Bosnia and Herzogovnia */
replace cty="BSF" if s003a==914 /* Bosnian Federation is officially part of BIH - Bosnia and Herzogovnia */

replace cty="BIH" if cty=="SRP" | cty=="BSF" /* Combine them into Bosnia and Herzogovnia*/
replace cty="SCG" if cty=="SRB" | cty=="MNE" /* Combine Serbia and Montenegro */
replace cty="DEU" if cty=="DEU" | cty=="DDR" /* Combine East and West Germany into one country */
gen oecd=.
for X in any AUT BEL CAN DNK FRA DEU GRC ISL IRL ITA LUX NLD NOR PRT ESP SWE CHE TUR GBR USA JPN FIN AUS NZL MEX CZE KOR HUN POL SVK: replace oecd=1 if cty=="X"


gen str30 country=""
replace country="Albania" if s003a==8
replace country="Algeria" if s003a==12
replace country="Azerbaijan" if s003a==31
replace country="Argentina" if s003a==32
replace country="Australia" if s003a==36
replace country="Austria" if s003a==40
replace country="Bangladesh" if s003a==50
replace country="Armenia" if s003a==51
replace country="Belgium" if s003a==56
replace country="Brazil" if s003a==76
replace country="Bulgaria" if s003a==100
replace country="Belarus" if s003a==112
replace country="Canada" if s003a==124
replace country="Chile" if s003a==152
replace country="China" if s003a==156
replace country="Taiwan" if s003a==158
replace country="Colombia" if s003a==170
replace country="Croatia" if s003a==191
replace country="Czech Republic" if s003a==203
replace country="Denmark" if s003a==208
replace country="Dominican Republic" if s003a==214
replace country="El Salvador" if s003a==222
replace country="Estonia" if s003a==233
replace country="Finland" if s003a==246
replace country="France" if s003a==250
replace country="Georgia" if s003a==268
replace country="Greece" if s003a==300
replace country="Hungary" if s003a==348
replace country="Iceland" if s003a==352
replace country="India" if s003a==356
replace country="Indonesia" if s003a==360
replace country="Iran (Islamic Republic Of)" if s003a==364
replace country="Iraq" if s003a==368
replace country="Ireland" if s003a==372
replace country="Israel" if s003a==376
replace country="Italy" if s003a==380
replace country="Japan" if s003a==392
replace country="Jordan" if s003a==400
replace country="South Korea" if s003a==410
replace country="Kyrgyzstan" if s003a==417
replace country="Latvia" if s003a==428
replace country="Lithuania" if s003a==440
replace country="Luxembourg" if s003a==442
replace country="Malta" if s003a==470
replace country="Mexico" if s003a==484
replace country="Moldova" if s003a==498
replace country="Morocco" if s003a==504
replace country="Netherlands" if s003a==528
replace country="New Zealand" if s003a==554
replace country="Nigeria" if s003a==566
replace country="Norway" if s003a==578
replace country="Pakistan" if s003a==586
replace country="Peru" if s003a==604
replace country="Philippines" if s003a==608
replace country="Poland" if s003a==616
replace country="Portugal" if s003a==620
replace country="Puerto Rico" if s003a==630
replace country="Romania" if s003a==642
replace country="Russia" if s003a==643
replace country="Saudi Arabia" if s003a==682
replace country="Singapore" if s003a==702
replace country="Slovakia" if s003a==703
replace country="Viet Nam" if s003a==704
replace country="Slovenia" if s003a==705
replace country="South Africa" if s003a==710
replace country="Zimbabwe" if s003a==716
replace country="Spain" if s003a==724
replace country="Sweden" if s003a==752
replace country="Switzerland" if s003a==756
replace country="Turkey" if s003a==792
replace country="Uganda" if s003a==800
replace country="Ukraine" if s003a==804
replace country="Macedonia" if s003a==807
replace country="Egypt" if s003a==818
replace country="Great Britain" if s003a==826
replace country="Tanzania" if s003a==834
replace country="United States" if s003a==840
replace country="Uruguay" if s003a==858
replace country="Venezuela" if s003a==862
replace country="West Germany" if s003a==900
replace country="East Germany" if s003a==901
replace country="Northern Ireland" if s003a==909
replace country="Serbia" if s003a==911
replace country="Montenegro" if s003a==912
replace country="Srpska" if s003a==913
replace country="Bosnia Federation" if s003a==914

replace country="Bosnia & Herzegovina" if cty=="BIH"
replace country="Germany" if cty=="DEU"
replace country="Serbia & Montenegro" if cty=="SCG"

* Fix some bugs in the WVS (I checked with the survey folks on this.)
for X in var a010-a019: replace X=0 if X==2

* My variables
gen year=s020
gen sex=x001
gen wt=s017a
gen wt1000=s018a
gen wave=.
for X in num 1/4 \ Y in num 1982 1990 1996 2000: replace wave=Y if s002==X

gen sat=a170
gen hap=5-a008
gen freedom=a173
gen jobsat=c033

for X in var a010-a019 \ Y in any excited restless proud lonely pleased bored topoftheworld depressed goingmyway upset: gen feeling_Y=X 

gen age=x003
gen marital=x007
gen kids=x011

label define waves 1982 "1981-84 wave" 1990 "1989-93 wave" 1996 "1994-99 wave" 2000 "1999-2004 wave"
label values wave waves

* Add a marker for non-representative national samples (where there are no weights to correct this).
gen nonrepresentative=0
replace nonrepresentative=1 if cty=="ARG" & (wave==1982 | wave==1990 | wave==1996)
replace nonrepresentative=1 if cty=="BGD" & (wave==1996)
replace nonrepresentative=1 if cty=="CHL" & (wave==1990 | wave==1996)
replace nonrepresentative=2 if cty=="CHL" & (wave==2000)
replace nonrepresentative=1 if cty=="CHN" & (wave==1990)
replace nonrepresentative=2 if cty=="CHN" & (wave==1996)
replace nonrepresentative=1 if cty=="DOM" & (wave==1996)
replace nonrepresentative=1 if cty=="EGY" & (wave==2000)
replace nonrepresentative=1 if cty=="IND" & (wave==1990)
replace nonrepresentative=2 if cty=="IND" & (wave==1996)
replace nonrepresentative=1 if cty=="MEX" & (wave==1990)
replace nonrepresentative=1 if cty=="NGA" & (wave==1990)
replace nonrepresentative=2 if cty=="NGA" & (wave==1996)
replace nonrepresentative=1 if cty=="PAK" & (wave==1996)
replace nonrepresentative=1 if cty=="ZAF" & (wave==1990)



* Merge in GDP data
sort cty year
merge cty year using "Processed files\Complete_GDP.dta"
drop if _merge==2
tab country if _merge==1


xi: reg gdp i.cty*i.wave [aw=wt1000]
predict gdpav if gdp~=.
drop gdp
rename gdpav gdp
la var gdp "GDP per capita at PPP"
gen lgdp=ln(gdp)

egen ctywve=group(cty wave)
do "WVS\WVS income coding.do"
xi: reg inc i.s024a [pw=wt]
predict inchat if inc~=.
tomode inchat, by(s024a) replace
xi: reg lninc i.s024a [pw=wt]
predict lninchat if lninc~=.
tomode lninchat, by(s024a) replace
gen mld=ln(inchat)-lninchat
xi: reg mld i.ctywve [pw=wt]
predict mldav if mld~=.
tomode mldav, by (ctywve) replace
drop mld inchat lninchat
rename mldav mld

* Add in controls
replace age=-1 if age==.
gen age_missing=age==-1
for X in num 1/4: gen ageX=age^X \ gen fageX=ageX*(sex==2)
replace sex=-1 if sex==.
gen sex_missing=(sex==-1)
global controls "age1-age4 fage1-fage4 sex sex_missing age_missing"


compress
saveold "Processed files\WVS.dta", replace

use "Processed files\WVS", clear
xi: oprobit sat i.ctywve [pw=wt] 
predict sat_hat if sat~=., xb
xi: oprobit hap i.ctywve [pw=wt] 
predict hap_hat if hap~=., xb
for var sat_hat hap_hat: tomode X, by(ctywve) replace
egen tag=tag(ctywve)
for X in var hap_hat sat_hat: summ X if tag==1 \ replace X=X-r(mean)

xi i.ctywve
foreach v of varlist feeling_* {
	qui reg `v' _I* [pw=wt] 
	predict `v'_hat if `v'~=.
	tomode `v'_hat, by(ctywve) replace
}


keep if tag==1
for var sat_hat hap_hat: summ X \ replace X=X-r(mean)
keep gdp cgdp lgdp mld *_hat cty wave nonrepresentative oecd
saveold "Processed files\WVS_macro.dta", replace


